//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;

namespace Sink
{
	/// <summary>
	/// Podsumowanie dla EventSinkForm.
	/// </summary>
	public class EventSinkForm : System.Windows.Forms.Form
	{
		const string log = "MyEventLog";
		const string source = "MyEventSource";
		private System.Windows.Forms.ListBox messageListBox;
		private System.Diagnostics.EventLog eventLog;
		private System.Windows.Forms.Timer timer;
		private System.ComponentModel.IContainer components;

		public EventSinkForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			this.eventLog.Log = log;
			this.eventLog.Source = source;
			this.eventLog.SynchronizingObject = this;
			this.eventLog.EntryWritten += new System.Diagnostics.EntryWrittenEventHandler(this.OnEntryWritten);
			try
			{
				this.eventLog.EnableRaisingEvents = true;
			}
			catch(InvalidOperationException e)
			{
				// Prawdopodobnie nie ma jeszcze rda.
				// Ustawmy licznik, aby ponownie
				// poszuka rda.
				Debug.WriteLine(e);
				timer.Enabled = true;
			}
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.eventLog = new System.Diagnostics.EventLog();
			this.messageListBox = new System.Windows.Forms.ListBox();
			this.timer = new System.Windows.Forms.Timer(this.components);
			((System.ComponentModel.ISupportInitialize)(this.eventLog)).BeginInit();
			this.SuspendLayout();
			// 
			// eventLog
			// 
			this.eventLog.SynchronizingObject = this;
			// 
			// messageListBox
			// 
			this.messageListBox.HorizontalScrollbar = true;
			this.messageListBox.ItemHeight = 16;
			this.messageListBox.Location = new System.Drawing.Point(8, 8);
			this.messageListBox.Name = "messageListBox";
			this.messageListBox.Size = new System.Drawing.Size(408, 244);
			this.messageListBox.TabIndex = 0;
			// 
			// timer
			// 
			this.timer.Interval = 1000;
			this.timer.Tick += new System.EventHandler(this.OnTimerTick);
			// 
			// EventSinkForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(424, 260);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.messageListBox});
			this.Name = "EventSinkForm";
			this.Text = "Ujcie zdarze";
			((System.ComponentModel.ISupportInitialize)(this.eventLog)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new EventSinkForm());
		}

		private void OnEntryWritten(object sender, System.Diagnostics.EntryWrittenEventArgs e)
		{
			DateTime time = e.Entry.TimeGenerated;
			string entryType = e.Entry.EntryType.ToString();
			string message = e.Entry.Message;
			string id = Convert.ToString(e.Entry.EventID);
			string cat = Convert.ToString(e.Entry.CategoryNumber);
			messageListBox.Items.Add(time + " " + entryType + " " + message + " " + id + " " + cat);
		}

		private void OnTimerTick(object sender, System.EventArgs e)
		{
			try
			{
				this.eventLog.EnableRaisingEvents = true;
				timer.Enabled = false;
			}
			catch(InvalidOperationException exception)
			{
				timer.Enabled = true;
			}
		}
	}
}
